% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/triwa_sb.R
\name{triwa_sb}
\alias{triwa_sb}
\title{Titration Curve for Triprotic Weak Acid}
\usage{
triwa_sb(conc.acid = 0.1, conc.base = 0.1, pka1 = 4, pka2 = 7,
  pka3 = 10, pkw = 14, vol.acid = 50, plot = TRUE, eqpt = FALSE,
  overlay = FALSE, ...)
}
\arguments{
\item{conc.acid}{Molar concentration of the triprotic weak acid 
analyte; defaults to 0.10 M.}

\item{conc.base}{Molar concentration of the strong base titrant;
defaults to 0.10 M.}

\item{pka1}{The pKa1 value for the triprotic weak acid analyte; 
defaults to a pKa1 of 4.}

\item{pka2}{The pKa2 value for the triprotic weak acid analyte;
defaults to a pKa2 of 7.}

\item{pka3}{The pKa3 value for the triprotic weak acid analyte;
defaults to a pKa3 of 10.}

\item{pkw}{The pKw (or pKs) value for the solvent; defaults to water
as a solvent with a pKw of 14.}

\item{vol.acid}{The initial volume, in mL, of the solution that 
contains the weak acid analyte; defaults to 50.00 mL.}

\item{plot}{Logical; if TRUE, plots the titration curve.}

\item{eqpt}{Logical; if TRUE, draws a vertical line at the titration
curve's equivalence point.}

\item{overlay}{Logical; if TRUE, adds the current titration curve
to the existing titration curve.}

\item{\dots}{Additional arguments to pass to \code{plot()} function.}
}
\value{
A two-column data frame that contains the volume of titrant
in the first column and the solution's pH in the second column. Also
produces a plot of the titration curve with options to display the
equivalence point and to overlay titration curves.
}
\description{
This function calculates and plots the titration curve for a 
triprotic weak acid analyte using a monoprotic strong base as 
the titrant. The calculation uses a single master equation
that finds the volume of titrant needed to achieve a fixed pH, 
as outlined in R. de Levie's \emph{Principles of Quantitative 
Chemical Analysis} (McGraw-Hill, 1997).
}
\examples{
### Simple titration curve with equivalence points
ex7 = triwa_sb(eqpt = TRUE)
head(ex7)

### Overlay titration curves using different pKa1 and pKa2 values
triwa_sb(pka1 = 4, pka2 = 7, pka3 = 10, eqpt = TRUE)
triwa_sb(pka1 = 3, pka2 = 7, pka3 = 11, overlay = TRUE)
triwa_sb(pka1 = 5, pka2 = 7, pka3 = 9, overlay = TRUE)
}
\author{
David T. Harvey, DePauw University. \email{harvey@depauw.edu}
}

