% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_mapbox.R
\name{tm_maplibre}
\alias{tm_maplibre}
\title{Maplibre mode options}
\usage{
tm_maplibre(pitch)
}
\arguments{
\item{pitch}{The pitch angle}
}
\value{
a [tmap::tmap-element]
}
\description{
Maplibre mode options. These options are specific to the maplibre mode.
}
\examples{
\donttest{
library(tmap)
library(tmap.mapgl)
tmap_mode("maplibre")
tm_shape(World) +
  tm_polygons("HPI", fill.scale = tm_scale_intervals(values = "brewer.rd_yl_gn"))

tm_shape(NLD_dist) +
  tm_polygons("employment_rate",
    fill.scale = tm_scale_intervals(values = "scico.roma"),
    lwd = 0.1) +
  tm_shape(NLD_muni) +
	tm_polygons(fill = NULL, lwd = 1) +
tm_mapbox(pitch = 60) +
tm_basemap("carto.dark_matter")
}
}
