% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.group_tna_stability}
\alias{plot.group_tna_stability}
\title{Plot Centrality Stability Results}
\usage{
\method{plot}{group_tna_stability}(x, ...)
}
\arguments{
\item{x}{A \code{group_tna_stability} object.}

\item{...}{Arguments passed to \code{\link[=plot.tna_stability]{plot.tna_stability()}}.}
}
\value{
A \code{list} (invisibly) of \code{ggplot} objects displaying the stability
analysis plot.
}
\description{
Plot Centrality Stability Results
}
\examples{
model <- group_model(engagement_mmm)
# Low number of iterations for CRAN
stability <- estimate_cs(
  model,
  drop_prop = c(0.3, 0.5, 0.7, 0.9),
  iter = 10
)
plot(stability)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_permutation}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
