% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.tna_permutation}
\alias{plot.tna_permutation}
\title{Plot the Significant Differences from a Permutation Test}
\usage{
\method{plot}{tna_permutation}(x, colors, posCol = "#009900", negCol = "red", ...)
}
\arguments{
\item{x}{A \code{tna_permutation} object.}

\item{colors}{See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{posCol}{Color for plotting edges
the difference in edge weights is positive. See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{negCol}{Color for plotting edges when
the the difference in edge weights is negative. See \code{\link[qgraph:qgraph]{qgraph::qgraph()}}.}

\item{...}{Arguments passed to \code{\link[=plot_model]{plot_model()}}.}
}
\value{
A \code{qgraph} object containing only the significant edges according
to the permutation test.
}
\description{
Plot the Significant Differences from a Permutation Test
}
\examples{
model_x <- tna(group_regulation[1:200, ])
model_y <- tna(group_regulation[1001:1200, ])
# Small number of iterations for CRAN
perm <- permutation_test(model_x, model_y, iter = 20)
plot(perm)

}
\seealso{
Validation functions
\code{\link{bootstrap}()},
\code{\link{deprune}()},
\code{\link{estimate_cs}()},
\code{\link{permutation_test}()},
\code{\link{permutation_test.group_tna}()},
\code{\link{plot.group_tna_bootstrap}()},
\code{\link{plot.group_tna_permutation}()},
\code{\link{plot.group_tna_stability}()},
\code{\link{plot.tna_bootstrap}()},
\code{\link{plot.tna_reliability}()},
\code{\link{plot.tna_stability}()},
\code{\link{print.group_tna_bootstrap}()},
\code{\link{print.group_tna_permutation}()},
\code{\link{print.group_tna_stability}()},
\code{\link{print.summary.group_tna_bootstrap}()},
\code{\link{print.summary.tna_bootstrap}()},
\code{\link{print.tna_bootstrap}()},
\code{\link{print.tna_clustering}()},
\code{\link{print.tna_permutation}()},
\code{\link{print.tna_reliability}()},
\code{\link{print.tna_stability}()},
\code{\link{prune}()},
\code{\link{pruning_details}()},
\code{\link{reliability}()},
\code{\link{reprune}()},
\code{\link{summary.group_tna_bootstrap}()},
\code{\link{summary.tna_bootstrap}()}
}
\concept{validation}
