% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolbox.R
\name{pasteCols}
\alias{pasteCols}
\title{Paste together columns of a list/data frame}
\usage{
pasteCols(
  x,
  sep = " ",
  collapse = NULL,
  use_paste0 = FALSE,
  cols = NULL,
  by_name = FALSE
)
}
\arguments{
\item{x}{A list or data frame.}

\item{sep}{A character sting to separate the terms.}

\item{collapse}{An optional character string to separate the results.}

\item{use_paste0}{Boolean, if TRUE, will call paste0 instead of paste.}

\item{cols}{An optional vector of column positions or names to paste together. If passing column names, set by_name to TRUE.
The order of items in cols determines the order of the paste result.}

\item{by_name}{Boolean, if TRUE, it quotes the items in cols to properly index the list by name (x[[1]] vs x[["col_a"]]).}
}
\value{
A string with the values in each column pasted together.
}
\description{
Paste together columns of a list/data frame
}
\examples{
pasteCols(list("x" = c(1, 2, 3), "y" = c("a", "b", "c")))
}
