% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cuda.R
\name{cuda_record_memory_history}
\alias{cuda_record_memory_history}
\title{Enable Recording of Memory Allocation Stack Traces}
\usage{
cuda_record_memory_history(
  enabled,
  context = "all",
  stacks = "all",
  max_entries = 1
)
}
\arguments{
\item{enabled}{Character or \code{NULL}. Controls memory history recording. Options:
\describe{
\item{\code{NULL}}{Disable recording of memory history.}
\item{\code{"state"}}{Record currently allocated memory information.}
\item{\code{"all"}}{Record the history of all allocation and free events (default).}
}}

\item{context}{Character or \code{NULL}. Controls traceback recording. Options:
\describe{
\item{\code{NULL}}{Do not record any tracebacks.}
\item{\code{"state"}}{Record tracebacks for currently allocated memory.}
\item{\code{"alloc"}}{Record tracebacks for allocation events.}
\item{\code{"all"}}{Record tracebacks for both allocation and free events (default).}
}}

\item{stacks}{Character. Defines the stack trace frames to include. Options:
\describe{
\item{\code{"all"}}{Include all frames (default).}
}}

\item{max_entries}{Integer. The maximum number of allocation/free events to retain.}
}
\value{
None; function invoked for side effects.
}
\description{
Enables recording of stack traces associated with memory allocations, allowing
users to identify the source of memory allocation in CUDA snapshots.
}
\details{
Alongside tracking stack traces for each current allocation and free event,
this function can also keep a historical log of all allocation and free events.

Use \code{cuda_memory_snapshot()} to retrieve recorded information. Visualization
can be performed using \href{https://docs.pytorch.org/memory_viz}{pytorch.org/memory_viz}.
}
\examples{
if (torch_is_installed()) {
\dontrun{
cuda_record_memory_history(enabled = 'all', context = 'all', stacks = 'all', max_entries = 10000)
}
}
}
