% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models-convnext.R
\name{model_convnext}
\alias{model_convnext}
\alias{model_convnext_tiny_1k}
\alias{model_convnext_tiny_22k}
\alias{model_convnext_small_22k}
\alias{model_convnext_small_22k1k}
\alias{model_convnext_base_1k}
\alias{model_convnext_base_22k}
\alias{model_convnext_large_1k}
\alias{model_convnext_large_22k}
\title{ConvNeXt Implementation}
\usage{
model_convnext_tiny_1k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 1000,
  ...
)

model_convnext_tiny_22k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 21841,
  ...
)

model_convnext_small_22k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 21841,
  ...
)

model_convnext_small_22k1k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 21841,
  ...
)

model_convnext_base_1k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 1000,
  ...
)

model_convnext_base_22k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 21841,
  ...
)

model_convnext_large_1k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 1000,
  ...
)

model_convnext_large_22k(
  pretrained = FALSE,
  progress = TRUE,
  channels = 3,
  num_classes = 21841,
  ...
)
}
\arguments{
\item{pretrained}{(bool): If TRUE, returns a model pre-trained on ImageNet.}

\item{progress}{(bool): If TRUE, displays a progress bar of the download to
stderr.}

\item{channels}{The number of channels in the input image.  Default: 3.}

\item{num_classes}{number of output classes (default: 1000).}

\item{...}{Other parameters passed to the model implementation.}
}
\description{
Implements the ConvNeXt architecture from \href{https://arxiv.org/pdf/2201.03545}{ConvNeXt: A ConvNet for the 2020s}
}
\section{Functions}{
\itemize{
\item \code{model_convnext_tiny_1k()}: ConvNeXt Tiny model trained on Imagenet 1k.

\item \code{model_convnext_tiny_22k()}: ConvNeXt Tiny model trained on Imagenet 22k.

\item \code{model_convnext_small_22k()}: ConvNeXt Small model trained on Imagenet 22k.

\item \code{model_convnext_small_22k1k()}: ConvNeXt Small model pretrained on Imagenet 1k
and fine-tuned on Imagenet 22k classes.

\item \code{model_convnext_base_1k()}: ConvNeXt Base model trained on Imagenet 1k.

\item \code{model_convnext_base_22k()}: ConvNeXt Base model trained on Imagenet 22k.

\item \code{model_convnext_large_1k()}: ConvNeXt Large model trained on Imagenet 1k.

\item \code{model_convnext_large_22k()}: ConvNeXt Large model trained on Imagenet 22k.

}}
\section{Variants}{

\subsection{Model Summary and Performance for pretrained weights}{

\if{html}{\out{<div class="sourceCode">}}\preformatted{| Model                | Top-1 Acc| Params | GFLOPS | File Size | `num_classes`| image size |
|----------------------|----------|--------|--------|-----------|--------------|------------|
| convnext_tiny_1k     | 82.1\%    | 28M    | 4.5    | 109 MB    |         1000 | 224 x 224  |
| convnext_tiny_22k    | 82.9\%    | 29M    | 4.5    | 170 MB    |        21841 | 224 x 224  |
| convnext_small_22k   | 84.6\%    | 50M    | 8.7    | 252 MB    |        21841 | 224 x 224  |
| convnext_small_22k1k | 84.6\%    | 50M    | 8.7    | 252 MB    |        21841 | 224 x 224  |
| convnext_base_1k     | 85.1\%    | 89M    | 15.4   | 338 MB    |         1000 | 224 x 224  |
| convnext_base_22k    | 85.8\%    | 89M    | 15.4   | 420 MB    |        21841 | 224 x 224  |
| convnext_large_1k    | 84.3\%    | 198M   | 34.4   | 750 MB    |         1000 | 224 x 224  |
| convnext_large_22k   | 86.6\%    | 198M   | 34.4   | 880 MB    |        21841 | 224 x 224  |
}\if{html}{\out{</div>}}
}
}

\examples{
\dontrun{
# 1. Download sample image (dog)
norm_mean <- c(0.485, 0.456, 0.406) # ImageNet normalization constants, see
# https://pytorch.org/vision/stable/models.html
norm_std  <- c(0.229, 0.224, 0.225)
img_url <- "https://en.wikipedia.org/wiki/Special:FilePath/Felis_catus-cat_on_snow.jpg"
img <- base_loader(img_url)

# 2. Convert to tensor (RGB only), resize and normalize
input <- img \%>\%
 transform_to_tensor() \%>\%
 transform_resize(c(224, 224)) \%>\%
 transform_normalize(norm_mean, norm_std)
batch <- input$unsqueeze(1)

# 3. Load pretrained models
model_small <- convnext_tiny_1k(pretrained = TRUE, root = tempdir())
model_small$eval()

# 4. Forward pass
output_s <- model_small(batch)

# 5. Show Top-5 predictions
topk <- output_s$topk(k = 5, dim = 2)
indices <- as.integer(topk[[2]][1, ])
scores <- as.numeric(topk[[1]][1, ])
glue::glue("{seq_along(indices)}. {imagenet_label(indices)} ({round(scores, 2)}\%)")
}

}
\seealso{
Other classification_model: 
\code{\link{model_alexnet}()},
\code{\link{model_efficientnet}},
\code{\link{model_efficientnet_v2}},
\code{\link{model_facenet}},
\code{\link{model_inception_v3}()},
\code{\link{model_maxvit}()},
\code{\link{model_mobilenet_v2}()},
\code{\link{model_mobilenet_v3}},
\code{\link{model_resnet}},
\code{\link{model_vgg}},
\code{\link{model_vit}}
}
\concept{classification_model}
