% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_beast_posterior.R
\encoding{UTF-8}
\name{parse_beast_posterior}
\alias{parse_beast_posterior}
\title{Parses BEAST2 output files to a posterior}
\usage{
parse_beast_posterior(
  trees_filenames,
  tracelog_filename,
  log_filename = "deprecated"
)
}
\arguments{
\item{trees_filenames}{the names of one or more a BEAST2
posterior \code{.trees} file.
Each \code{.trees} file can be read using \link{parse_beast_trees}}

\item{tracelog_filename}{name of the BEAST2 tracelog \code{.log} output file,
as can be read using \link{parse_beast_tracelog_file}}

\item{log_filename}{deprecated name
of the BEAST2 tracelog \code{.log} output file.
Use \code{tracelog_filename} instead}
}
\value{
a list with the following elements:\cr
  \itemize{
    \item \code{estimates}: parameter estimates
    \item
      \code{[alignment_id]_trees}: the phylogenies in the
      BEAST2 posterior. \code{[alignment_id]} is the ID
      of the alignment.
  }
}
\description{
Parses BEAST2 output files to a posterior
}
\examples{
trees_filenames <- get_tracerer_path("beast2_example_output.trees")
tracelog_filename <- get_tracerer_path("beast2_example_output.log")
posterior <- parse_beast_posterior(
  trees_filenames = trees_filenames,
  tracelog_filename = tracelog_filename
)
}
\seealso{
Use \code{\link{remove_burn_ins}} to remove the burn-ins from
  the posterior's estimates (\code{posterior$estimates})
}
\author{
Richèl J.C. Bilderbeek
}
