% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.xgb.Booster.prmdt}
\alias{predict.xgb.Booster.prmdt}
\title{predict.xgb.Booster}
\usage{
\method{predict}{xgb.Booster.prmdt}(
  object,
  newdata,
  type = "class",
  missing = NA,
  outputmargin = FALSE,
  ntreelimit = NULL,
  predleaf = FALSE,
  predcontrib = FALSE,
  approxcontrib = FALSE,
  predinteraction = FALSE,
  reshape = FALSE,
  ...
)
}
\arguments{
\item{object}{a \code{\link[xgboost]{xgb.train}} model object for which prediction is desired.}

\item{newdata}{an optional data frame in which to look for variables with which to predict.}

\item{type}{type of prediction 'prob' or 'class' (default).}

\item{missing}{Missing is only used when input is dense matrix. Pick a float value that represents missing values in data (e.g., sometimes 0 or some other extreme value is used).}

\item{outputmargin}{whether the prediction should be returned in the for of original untransformed sum of predictions from boosting iterations' results. E.g., setting outputmargin=TRUE for logistic regression would result in predictions for log-odds instead of probabilities.}

\item{ntreelimit}{Deprecated, use iterationrange instead.}

\item{predleaf}{whether predict leaf index.}

\item{predcontrib}{whether to return feature contributions to individual predictions (see Details).}

\item{approxcontrib}{whether to use a fast approximation for feature contributions (see Details).}

\item{predinteraction}{whether to return contributions of feature interactions to individual predictions (see Details).}

\item{reshape}{whether to reshape the vector of predictions to a matrix form when there are several prediction outputs per case. This option has no effect when either of predleaf, predcontrib, or predinteraction flags is TRUE.}

\item{...}{additional arguments affecting the predictions produced.}
}
\value{
a vector or matrix of predictions for xgb model.
}
\description{
Return prediction for a \code{\link[xgboost]{xgb.train}} model.
}
