% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trajeRmodelSelection.R
\name{trajeRBIC}
\alias{trajeRBIC}
\title{BIC function to an trajectory object}
\usage{
trajeRBIC(sol)
}
\arguments{
\item{sol}{Trajectory's object. An object of type trajectory.}
}
\value{
A real.
}
\description{
Calculate the BIC value to an trajectory object.
}
\examples{
data <- read.csv(system.file("extdata", "CNORM2gr.csv", package = "trajeR"))
data <- as.matrix(data)
sol <- trajeR(Y = data[, 2:6], A = data[, 7:11], degre = c(2, 2), Model = "CNORM", Method = "EM")
trajeRBIC(sol)
}
