% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speed.R
\name{TrajAcceleration}
\alias{TrajAcceleration}
\title{Approximates the acceleration of a trajectory}
\usage{
TrajAcceleration(trj)
}
\arguments{
\item{trj}{Trajectory whose acceleration is to be calculated.}
}
\value{
Vector of complex numbers. The modulus (\code{Mod(a)}) is the
  magnitude of the acceleration at each point, and the argument
  (\code{Arg(a)}) is the direction of the acceleration. The vector has an
  attribute, \code{trj}, with the trajectory as its value. The first and last
  values will always be \code{NA}, since acceleration cannot be estimated for
  those points.
}
\description{
Returns an approximation of the acceleration of a trajectory at each point
using the second-order central finite differences.
}
\details{
`trajr` trajectories, which consist of straight line displacements between
sampled locations, do not contain enough information to correctly derive
velocity or acceleration. Since we have to assume a constant velocity at each
step, the first derivative is discontinuous. Acceleration, therefore, is zero
during each step and infinite at each change of velocity. The approximation
implemented by this function assumes that acceleration occurs over a period
of time: half the duration of the previous step plus half the duration of the
next step.
}
\examples{
# A function to plot acceleration as arrows (scaled in length)
AccArrows <- function(acc, scale = .001, trj = attr(acc, "trj"), ...) {
  graphics::arrows(trj$x, trj$y, trj$x + Re(acc) * scale, trj$y + Im(acc) * scale, ...)
}

# Generate and plot a random trajectory
set.seed(101)
trj <- TrajGenerate(30)
plot(trj)

# Calculate acceleration
acc <- TrajAcceleration(trj)
# Plot acceleration as red arrows at each point. They need to be scaled down to
# fit in the plot, and the arrowhead lengths need to be shortened to look good
AccArrows(acc, scale = .001, col = "red", length = .1)

}
\seealso{
\code{\link{TrajVelocity}} for calculating velocity,
  \code{\link{TrajResampleTime}} and \code{\link{TrajRediscretize}} to
  resample a trajectory to fixed time or length steps.
}
