% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dlo.R
\name{MASS_mvrnorm}
\alias{MASS_mvrnorm}
\title{Multivariate Normal (Gaussian) Distribution}
\usage{
MASS_mvrnorm(n = 1, mu, Sigma, tol = 1e-06, empirical = FALSE, EISPACK = FALSE)
}
\arguments{
\item{n}{Numeric integer.
The number of observations to generate.}

\item{mu}{Numeric vector.
The mean vector of the multivariate normal distribution.}

\item{Sigma}{Numeric matrix.
The covariance matrix of the multivariate normal distribution.}

\item{tol}{Numeric.
Tolerance for checking the positive definiteness of the covariance matrix.}

\item{empirical}{Logical.
Whether to return the empirical covariance matrix.}

\item{EISPACK}{Logical.
Whether to use the EISPACK routine instead of the LINPACK routine.}
}
\value{
A (n X p) matrix of random observations from the multivariate normal distribution.
Updated: 26.10.2023.
}
\description{
This function generates a random sample from the multivariate normal distribution with mean mu and covariance matrix Sigma.
}
