% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_count_label.r
\name{small_count_label}
\alias{small_count_label}
\title{Label Small Counts Based on a Cutoff}
\usage{
small_count_label(var, cutoff, replacement)
}
\arguments{
\item{var}{A numeric vector. This represents the variable to be checked
against the cutoff.}

\item{cutoff}{A numeric value representing the threshold. Values in \code{var}
smaller than this value will be replaced.}

\item{replacement}{A string or a numeric value. If the value in \code{var} is
smaller than the \code{cutoff}, this value will replace it. If a string is
provided, it will replace the numeric values with the string. If a numeric
value is provided, the replacement will also be numeric.}
}
\value{
A vector with values from \code{var}. Values smaller than the \code{cutoff}
will be replaced by the \code{replacement}. If \code{replacement} is a string, the
return type will be character, otherwise, it will remain numeric.
}
\description{
This function labels values in a vector as a replacement string if they are
smaller than a specified cutoff. The input can be numeric, and the function
will return either a modified version of the input vector with small values
replaced by a given label, or it will keep the original values otherwise.
}
\examples{
# Example usage of the small_count_label function
small_count_label(c(1, 5, 10), 5, "Below Cutoff")
small_count_label(c(1, 5, 10), 5, 0)

}
\author{
Nicolas Foss, Ed.D., MS
}
