% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.treats.R
\name{plot.treats}
\alias{plot.treats}
\title{Plot treats objects}
\usage{
\method{plot}{treats}(
  x,
  col,
  ...,
  trait = 1,
  edges = "grey",
  tips.nodes = NULL,
  use.3D = FALSE,
  simulations = 20,
  cent.tend = mean,
  quantiles = c(95, 50),
  legend = FALSE,
  transparency,
  add = FALSE
)
}
\arguments{
\item{x}{\code{treats} data.}

\item{col}{Optional, a \code{vector} of colours that can be named or a \code{function} (see details).}

\item{...}{Any additional options to be passed to plot functions (from \code{graphics} or \code{rgl} if \code{use.3D = TRUE}).}

\item{trait}{which trait to plot (default is \code{1}; see details).}

\item{edges}{either a colour name to attribute to the edges or \code{NULL} to not display the edges (default is \code{"grey"}).}

\item{tips.nodes}{optional, a colour to circle tips and nodes (only used if \code{use.3D = FALSE}). By default \code{tips.nodes = NULL}.}

\item{use.3D}{logical, whether to use a 3D plot or not (default is \code{FALSE}; see details).}

\item{simulations}{if the input is a \code{treats} \code{traits} or \code{bd.params} object, how many replicates to run (default is \code{50}).}

\item{cent.tend}{if the input is a \code{treats} \code{traits}, which central tendency to plot (default is \code{mean}).}

\item{quantiles}{if the input is a \code{treats} \code{traits}, which quantiles to plot (default are \code{c(95, 50))}).}

\item{legend}{logical, whether to display the legend in 2D plots (\code{TRUE}) or not (\code{FALSE}; default)}

\item{transparency}{Optional, a transparency factor (\code{1} = not transparent, \code{0} = invisible). If left empty, and multiple plots are called, the transparency is set to 1 / number of plots + 0.1.}

\item{add}{logical, whether to add to a previous plot.}
}
\value{
No return value, plot \code{x}'s content.
}
\description{
Plotting treats objects (either a simulated tree and trait(s) or a process for traits objects)
}
\details{
The \code{col} option can be either:
\itemize{
     \item a \code{vector} of colours to be applied to \code{"treats"} \code{"traits"} objects (for respectively the median, 50% CI and 95% CI - by default this is \code{col = c("black", "grey", "lightgrey")}). This is the default option when plotting traits.
     \item a \code{vector} of colours to be applied to \code{"treats"} objects for the colours of different elements of the plot. This vector is applied to all the elements in the tree using the order in \code{tree$tip.label} and \code{tree$node.label}.
     \item an unambiguous named \code{vector} for colouring each specific elements. These can be any of the following (with default colours) \code{col = c("nodes" = "orange", "fossils" = "lightblue", "livings" = "blue")} or \code{"tips"} to designate both livings and fossils and \code{"singletons"} to designate non-bifurcating nodes.
     \item a \code{function} from which to sample the colours to match the time gradient for each element.
}

The \code{trait} option can intake from 1 to 3 traits (if \code{use.3D = TRUE}). If two traits are given (e.g. \code{c(1, 2)}), the default plots a correlation plot between both traits (same for 3 traits if \code{use.3D = TRUE}).

The \code{use.3D} option uses the \code{rgl} library to create a 3D plot. The plot displays either a time on the Z axis with two traits on the X and Y axis (if two traits are requested via \code{trait}) or three traits on the X Y and Z (if three traits a requested via \code{trait}).
}
\examples{
## Specifying a trait process
my_trait <- make.traits()
## Plotting a trait process
plot(my_trait, main = "A Brownian Motion")

## Simulating a tree with ten taxa
my_tree <- treats(stop.rule = list(max.taxa = 10))
## Plotting a simple birth death tree (using ape::plot.phylo)
plot(my_tree, main = "A pure birth tree")

## Simulating a tree with traits
my_data <- treats(stop.rule = list(max.taxa = 100),
                  traits    = my_trait)
## Plotting the tree and traits
plot(my_data)

## Specifying a 3D trait process
my_3D_trait <- make.traits(n = 3)
## Simulating a birth death tree with that trait
my_data <- treats(bd.params = list(extinction = 0.2),
                  stop.rule = list(max.living = 50),
                  traits    = my_3D_trait)

## Plotting the second trait and the tree (default)
## The colours are purple for nodes and blue for tips
## with a black circle for highlighting the tips
plot(my_data, trait = 2,
     col = c("nodes" = "purple", "tips" = "blue"),
     edges = "pink", tips.nodes = "black")

## Plotting the first and third trait correlation
## The colours are a heat map based on the elements age
plot(my_data, trait = c(1,3), col = terrain.colors,
     edges = "grey", tips.nodes = "black")

## Plotting the first and third trait correlation in 3D
plot(my_data, trait = c(1,3), col = rainbow,
     edges = "grey", tips.nodes = "black", use.3D = TRUE)
#rglwidget() # to display the plot with non-default OpenRGL

## Plotting all traits in 3D (without branch lengths)
plot(my_data, trait = c(1:3), col = heat.colors,
     edges = NULL, tips.nodes = "black", use.3D = TRUE)
#rglwidget() # to display the plot with non-default OpenRGL

}
\seealso{
\code{\link{treats}}
}
\author{
Thomas Guillerme
}
