% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MDI.R
\name{MDITree}
\alias{MDITree}
\alias{MDI}
\title{Mean Decrease in Impurity}
\usage{
MDITree(tidy.RF, tree, trainX, trainY)

MDI(tidy.RF, trainX, trainY)
}
\arguments{
\item{tidy.RF}{A tidy random forest. The random forest to calculate MDI
from.}

\item{tree}{An integer. The index of the tree to look at.}

\item{trainX}{A data frame. Train set features, such that the \code{T}th
tree is trained with \code{X[tidy.RF$inbag.counts[[T]], ]}.}

\item{trainY}{A data frame. Train set responses, such that the \code{T}th
tree is trained with \code{Y[tidy.RF$inbag.counts[[T]], ]}.}
}
\value{
A matrix. The content depends on the type of the response.
  \itemize{
    \item Regression: A P-by-1 matrix, where P is the number of features in
      \code{X}. The pth row contains the MDI of feature p.
    \item Classification: A P-by-D matrix, where P is the number of features
      in \code{X} and D is the number of response classes. The dth column of
      the pth row contains the MDI of feature p to class d. You can get the
      MDI of each feature by calling \code{rowSums} on the result.
 }
}
\description{
Calculate the MDI feature importance measure.
}
\details{
MDI stands for Mean Decrease in Impurity. It is a widely adopted measure of
feature importance in random forests. In this package, we calculate MDI with
a new analytical expression derived by Li et al. (See references)

See \code{vignette('MDI', package='tree.interpreter')} for more context.
}
\section{Functions}{
\itemize{
\item \code{MDITree}: Mean decrease in impurity within a single tree

\item \code{MDI}: Mean decrease in impurity within the whole forest
}}

\examples{
library(ranger)
rfobj <- ranger(Species ~ ., iris, keep.inbag=TRUE)
tidy.RF <- tidyRF(rfobj, iris[, -5], iris[, 5])
MDITree(tidy.RF, 1, iris[, -5], iris[, 5])
MDI(tidy.RF, iris[, -5], iris[, 5])

}
\references{
A Debiased MDI Feature Importance Measure for Random Forests
  \url{https://arxiv.org/abs/1906.10845}
}
\seealso{
\code{\link{MDIoob}}

\code{vignette('MDI', package='tree.interpreter')}
}
