% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tricolore.R
\name{TernaryMeshCentroids}
\alias{TernaryMeshCentroids}
\title{Centroid Coordinates of Sub-Triangles in Segmented Equilateral Triangle}
\usage{
TernaryMeshCentroids(k)
}
\arguments{
\item{k}{Number of rows in the segmented equilateral triangle.}
}
\value{
A numeric matrix of with index and barycentric centroid coordinates
  of regions id=1,...,k^2.
}
\description{
Segment an equilateral triangle into k^2 equilateral sub-triangles and return
the barycentric centroid coordinates of each sub-triangle.
}
\examples{
# NOTE: only intended for internal use and not part of the API
tricolore:::TernaryMeshCentroids(1)
tricolore:::TernaryMeshCentroids(2)
tricolore:::TernaryMeshCentroids(3)

}
\references{
S. H. Derakhshan and C. V. Deutsch (2009): A Color Scale for Ternary Mixtures.
}
\keyword{internal}
