% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessors.R, R/triptych_mcbdsc.R,
%   R/triptych_murphy.R, R/triptych_reliability.R, R/triptych_roc.R
\name{regions}
\alias{regions}
\alias{regions.triptych_mcbdsc}
\alias{regions.triptych_murphy}
\alias{regions.triptych_reliability}
\alias{regions.triptych_roc}
\title{Accessing confidence/consistency region data}
\usage{
regions(x, ...)

\method{regions}{triptych_mcbdsc}(x, ...)

\method{regions}{triptych_murphy}(x, ...)

\method{regions}{triptych_reliability}(x, ...)

\method{regions}{triptych_roc}(x, ...)
}
\arguments{
\item{x}{An object from which the region information should be extracted.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A tibble with the relevant information for the
uncertainty quantification of the chosen diagnostic
(Murphy curve, reliability curve, ROC curve, score decomposition)
for all supplied forecasting methods.

For a Murphy curve, a tibble with columns: \code{forecast}, \code{threshold}, \code{lower}, \code{upper}, \code{method}, \code{level}.

For a reliability curve, a tibble with columns: \code{forecast}, \code{x} (forecast values), \code{lower}, \code{upper}, \code{method}, \code{level}.

For a ROC curve, a tibble with columns: \code{forecast}, \code{FAR} (false alarm rate), \code{HR} (hit rate), \code{method}, \code{level}.
This tibble is twice as long as those for Murphy and reliability curves,
since the FAR-HR pairs are ordered to describe a polygon, generated by pointwise confidence
intervals along diagonal lines with slope \eqn{-\pi_0/\pi_1}.
Here, \eqn{\pi_1 = 1 - \pi_0} is the unconditional event probability.
}
\description{
Accessing confidence/consistency region data
}
\examples{
data(ex_binary, package = "triptych")

# Bootstrap resampling is expensive
# (the number of bootstrap samples is small to keep execution times short)

tr <- triptych(ex_binary) |>
  dplyr::slice(1, 9) |>
  add_confidence(level = 0.9, method = "resampling_cases", n_boot = 20)

regions(tr$murphy)
regions(tr$reliability)
regions(tr$roc)

}
\seealso{
\code{\link[=estimates]{estimates()}}, \code{\link[=forecasts]{forecasts()}}, \code{\link[=observations]{observations()}}
}
