% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assess_phregr.R
\name{assess_phregr}
\alias{assess_phregr}
\title{Assess Proportional Hazards Assumption Based on Supremum Test}
\usage{
assess_phregr(object, resample = 1000, seed = 12345)
}
\arguments{
\item{object}{The output from the \code{phregr} call.}

\item{resample}{The number of simulation samples for the supremem test.}

\item{seed}{The random seed for the simulations.}
}
\value{
A list with the following components:
\itemize{
\item \code{time} the unique event times.
\item \code{score_t} the observed standardized score process.
\item \code{score_t_list} a list of simulated standardized score processes
under the null hypothesis.
\item \code{max_abs_value} the supremum of the absolute value of the observed
standardized score process for each covariate and the supremum of
the sum of absolute values of the observed standardized score processes
across all covariates.
\item \code{p_value} the p-values for the supremum tests for each covariate
and the global test.
}
}
\description{
Obtains the standardized score processes and the simulated
distribution under the null hypothesis as well as the p-values for
the supremum tests.
}
\details{
The supremum test corresponds to the ASSESS statement with \code{ph}
option of SAS PROC PHREG.
}
\examples{

fit <- phregr(data = liver, time = "Time", event = "Status", 
              covariates = c("log(Bilirubin)", "log(Protime)", 
                             "log(Albumin)", "Age", "Edema"),
              ties = "breslow")
              
aph <- assess_phregr(fit, resample = 1000, seed = 314159)
  
aph

plot(aph, nsim = 20)

}
\references{
D. Y. Lin, L. J. Wei, and Z. Ying.
Checking the Cox model with cumulative sums of martingale-based
residuals.
Biometrika 1993; 80:557-572.
}
\author{
Kaifeng Lu, \email{kaifenglu@gmail.com}
}
