% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_fil_ema.R
\name{ts_fil_ema}
\alias{ts_fil_ema}
\title{Exponential Moving Average (EMA)}
\usage{
ts_fil_ema(ema = 3)
}
\arguments{
\item{ema}{exponential moving average size}
}
\value{
A \code{ts_fil_ema} object.
}
\description{
Smooth a series by exponentially decaying weights that give more
importance to recent observations.
}
\details{
EMA is related to simple exponential smoothing; it reacts faster
to level changes than a simple moving average while reducing noise.
}
\examples{
# Exponential moving average smoothing on a noisy series
# Load package and example data
library(daltoolbox)
data(tsd)

# Inject an outlier to illustrate smoothing effect
tsd$y[9] <- 2 * tsd$y[9]

# Define EMA filter, fit and transform the series
filter <- ts_fil_ema(ema = 3)
filter <- fit(filter, tsd$y)
y <- transform(filter, tsd$y)

# Compare original vs smoothed series
plot_ts_pred(y = tsd$y, yadj = y)
}
\references{
\itemize{
\item C. C. Holt (1957). Forecasting trends and seasonals by exponentially
weighted moving averages. O.N.R. Research Memorandum.
}
}
