% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts_norm_swminmax.R
\name{ts_norm_swminmax}
\alias{ts_norm_swminmax}
\title{Sliding-Window Min–Max Normalization}
\usage{
ts_norm_swminmax(outliers = outliers_boxplot())
}
\arguments{
\item{outliers}{Indicate outliers transformation class. NULL can avoid outliers removal.}
}
\value{
A \code{ts_norm_swminmax} object.
}
\description{
Create an object for normalizing each window by its own min and
max, preserving local contrast while standardizing scales.
}
\examples{
# Per-window min–max normalization for sliding windows
# Load package and example data
library(daltoolbox)
data(tsd)

# Build 10-lag windows and preview raw scale
ts <- ts_data(tsd$y, 10)
ts_head(ts, 3)
summary(ts[,10])

# Fit per-window min–max and transform; inspect post-scale values
preproc <- ts_norm_swminmax()
preproc <- fit(preproc, ts)
tst <- transform(preproc, ts)
ts_head(tst, 3)
summary(tst[,10])
}
\references{
Ogasawara, E., Murta, L., Zimbrão, G., Mattoso, M. (2009). Neural networks
cartridges for data mining on time series. Proceedings of the International
Joint Conference on Neural Networks (IJCNN). doi:10.1109/IJCNN.2009.5178615
}
