% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_helpers.R
\name{wide_to_ts}
\alias{wide_to_ts}
\title{Transform a wide format data.frame into a tslist}
\usage{
wide_to_ts(data, keep_last_freq_only = FALSE, force_xts = FALSE)
}
\arguments{
\item{data}{data.frame The data.frame to be transformed}

\item{keep_last_freq_only}{in case there is a frequency change in a time
series, should only the part of the series be returned that has the same
frequency as the last observation.
This is useful when data start out crappy and then stabilize after a while.
Defaults to FALSE. Hence only the last part of the series is returned.}

\item{force_xts}{boolean force xts format? Defaults to FALSE.}
}
\description{
The time series in the data.frame may be stored either rowwise or
columnswise.
The identifying column must be called date (for columnwise) or series
(for rowwise)
}
