% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/residout.R
\name{residout}
\alias{residout}
\title{Residuals control chart}
\usage{
residout(resid, t = 2, outplot = c(TRUE, FALSE))
}
\arguments{
\item{resid}{vector of residuals.}

\item{t}{threshold value over which standardised residuals are regarded as outliers.}

\item{outplot}{if \code{TRUE}, then a control chart of the standardised residuals is plotted.}
}
\value{
A list containing:
\itemize{
\item \code{location}: locations of outliers.
\item \code{outliers}: values of outliers.
\item \code{residuals}: standardised residuals.
}
}
\description{
Create a control chart of residuals and identify outliers.
}
\examples{
residout(rnorm(50), outplot=TRUE)

}
\author{
Nikolaos Kourentzes, \email{nikolaos@kourentzes.com}.
}
\keyword{ts}
