% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvGarch_Sim.R
\name{tvGarch_Sim}
\alias{tvGarch_Sim}
\title{Generating Simulations using a tv-Garch Model}
\usage{
tvGarch_Sim(
  n,
  gamma,
  alpha,
  beta,
  type = c("polynomial", "NoLineal", "trigonometric"),
  exponentes = NULL,
  trig = NULL,
  arg = NULL
)
}
\arguments{
\item{n}{integer}

\item{gamma}{Vector containing coefficents of c.}

\item{alpha}{Vector containing coefficents of alpha.}

\item{beta}{Vector containing coefficents of beta.}

\item{type}{Vector of function type for c, alpha and beta.}

\item{exponentes}{Vector for exponenets in NoLineal.}

\item{trig}{Type of trigonometric function.}

\item{arg}{Value of argument for the trigonometric function.}
}
\value{
An object of class 'zoo' with two components: the first component represents returns, while the second component denotes conditional variance.
}
\description{
Simulate from a tv-Garch(1,1) model.
}
\examples{
## Simulate from a tv-GARCH(1,1) model lineal:
alpha_sim <- c(0.2, 0.2)
beta_sim <- c(0.45, 0.5, -0.85)
type_sim <- c("polynomial","polynomial","polynomial")
Sim1 <- tvGarch_Sim(n = 6000, gamma = 0.1, alpha = alpha_sim, beta = beta_sim, type = type_sim)
plot(Sim1[,1], type="l", main="Simulated tvGARCH(1, 1) process",
    ylim=c(-max(Sim1[,2]), max(Sim1[,2])))
lines(Sim1[,2], type="l", col="red")
legend("topright",legend=c("tvGARCH(1,1)",expression(sigma(u))),
      col=c("black","red"),lty=1,bty="n",lwd=1)
## Simulate from a tv-GARCH(1,1) model non linear:
alpha_sim2 <- c(0.75, 0.08)
beta_sim2 <- c(0.05, 0.03, 0.06)
type_sim2 <- c("polynomial","polynomial","NoLineal")
expo <- c(0, 1, 1/2)
Sim2<-tvGarch_Sim(n=6000,gamma=0.05,alpha=alpha_sim2,beta=beta_sim2,type=type_sim2,exponentes=expo)
plot(Sim2[,1], type="l", main="Simulated tvGARCH(1, 1) process",
     ylim=c(-max(Sim2[,2]),max(Sim2[,2])))
lines(Sim2[,2], type="l", col="red")
legend("topright",legend=c("tvGARCH(1,1)",expression(sigma(u))),
       col=c("black","red"),lty=1,bty="n",lwd=1)
}
