% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{count.events}
\alias{count.events}
\title{count.events}
\usage{
count.events(
  dat,
  outcome.names,
  grouping.variables = NULL,
  type = "overall",
  na.rm = TRUE
)
}
\arguments{
\item{dat}{A data frame structured as a panel data set.}

\item{outcome.names}{A character vector of variable names from dat that are expected
to be binary (1/0, TRUE/FALSE). The function calculates the count of these variables
being TRUE/1 in the specified interval. Variables not found in dat or not binary
will be disregarded.}

\item{grouping.variables}{A character vector of variable names from dat to group the
resulting counts. If NULL, the function computes the overall count without grouping.}

\item{type}{Specifies the counting method: "distinct" for counting only new occurrences
separated by zeros (useful for events like hospitalizations spanning multiple records),
or "overall" (default) for counting all records with the value of TRUE/1.}

\item{na.rm}{A logical indicating whether missing values should be ignored in the
calculations. Defaults to TRUE.}
}
\value{
Returns a data.table object containing the counts of events. The counts are
aggregated based on the specified 'grouping.variables'. Each row corresponds to a
group defined by 'grouping.variables' and contains counts of the specified
'outcome.names'. If 'type' is "distinct", the count reflects distinct occurrences of
events; if 'type' is "overall", it reflects the total count of records with TRUE/1
for the 'outcome.names'. The output structure makes it easy to understand the
distribution of events across the different groups or categories defined in the
data set.
}
\description{
Creates a count of the number of events that occurred within each group
from a panel data structure, based on specified binary outcome variables.
}
