% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tvtools.R
\name{panel.overlaps}
\alias{panel.overlaps}
\title{panel.overlaps}
\usage{
panel.overlaps(dat, id.name = "id", t1.name = "t1", t2.name = "t2")
}
\arguments{
\item{dat}{A data frame structured as panel data.}

\item{id.name}{The character name of the identifying variable within dat, used to
track subjects across multiple rows.}

\item{t1.name}{The character name of the time variable within dat representing the
start (left endpoint) of observation intervals.}

\item{t2.name}{The character name of the time variable within dat representing the
end (right endpoint) of observation intervals.}
}
\value{
Returns a data table listing subjects (identified by id.name) who have at least
one instance of overlapping observation periods. Each row corresponds to a unique subject
identified as having overlaps, with additional information or indicators related to the
nature or extent of these overlaps. This output is crucial for data cleaning and ensuring
the temporal accuracy of the panel data, allowing researchers to identify and rectify
anomalies before conducting further analysis.
}
\description{
Identifies records within a panel data set that have overlapping observation
periods for the same subject. Overlaps can indicate data entry errors or issues with
data collection protocols.
}
