% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.mediation.R
\name{summary.mediation}
\alias{summary.mediation}
\title{Displays a useful description of a \code{mediation} object}
\usage{
\method{summary}{mediation}(object, ...)
}
\arguments{
\item{object}{A \code{mediation} object}

\item{...}{Additional arguments.}
}
\value{
\item{ps_tables}{Table of observations' propensity scores}

\item{mediator_distribution_check}{balance tables for NIE_1 and NIE_0}
}
\description{
Displays a useful description of a \code{mediation} object
}
\examples{
data("tMdat")

## tMdat is small simulated data set included in twangMediation for 
## demonstrating the functions. See ?tMdat for details

## The tMdat data contains the following variables
## See ?tMdat for details

fit.es.max <- wgtmed(M ~ w1 + w2 + w3,
                      data = tMdat,
                      a_treatment = "A",
                      y_outcome = "Y",
                      total_effect_wts = tMdat$te.wgt,
                      method = "ps",
                      ps_n.trees=1500,
                      ps_shrinkage=0.01,
                      ps_stop.method=c("es.max")
                      )

summary(fit.es.max)
}
\seealso{
\code{\link{wgtmed}}
}
