% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_send_message.R
\name{tw_send_message}
\alias{tw_send_message}
\title{Send an SMS or MMS Message}
\usage{
tw_send_message(to, from, body = NULL, media_url = NULL)
}
\arguments{
\item{to}{A phone number which will receieve the message.}

\item{from}{A phone number which will send the message.}

\item{body}{The body of the message.}

\item{media_url}{A url containing media to be sent in a message.}
}
\value{
A \code{twilio_message} object.
}
\description{
Send an SMS or MMS Message
}
\examples{
\dontrun{

# Set API credentials
# You only need to do this once per R session
Sys.setenv(TWILIO_SID = "M9W4Ozq8BFX94w5St5hikg7UV0lPpH8e56")
Sys.setenv(TWILIO_TOKEN = "483H9lE05V0Jr362eq1814Li2N1I424t")

# Send a simple text message
tw_send_message("2125557634", "9178675903", "Hello from R!")

# Send a picture message
tw_send_message("2125557634", "9178675903", media_url = "https://www.r-project.org/logo/Rlogo.png")

# Send a picture message with text
tw_send_message("2125557634", "9178675903", "Do you like the new logo?",
    "https://www.r-project.org/logo/Rlogo.png")

}
}

