% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_loading.R
\name{copy_default_params}
\alias{copy_default_params}
\title{Copy Default Parameters File}
\usage{
copy_default_params(dest_dir)
}
\arguments{
\item{dest_dir}{Character. The path to the directory where the \code{params.yaml}
file will be copied.}
}
\value{
Nothing is returned. A message is displayed upon successful copying.
}
\description{
Copies the default \code{params.yaml} file, included with the package, to a
specified destination directory. This is useful for initializing parameter
files for custom edits.
}
\details{
The \code{params.yaml} file contains default model parameters for various
configurations such as LightGBM, dynamic regression, and others. See the
\code{\link[ubair:load_params]{load_params()}}` documentation for an example of the file's structure.
}
\examples{
copy_default_params(tempdir())
}
