% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factorLoadingDiamondCIplot.R
\name{factorLoadingDiamondCIplot}
\alias{factorLoadingDiamondCIplot}
\title{Two-dimensional visualisation of factor analyses}
\usage{
factorLoadingDiamondCIplot(
  fa,
  xlab = "Factor Loading",
  colors = viridisPalette(max(2, fa$factors)),
  labels = NULL,
  theme = ggplot2::theme_bw(),
  sortAlphabetically = FALSE,
  ...
)
}
\arguments{
\item{fa}{The object produced by the \code{\link[psych:fa]{psych::fa()}} function from the
\link[psych:00.psych-package]{psych::psych} package. It is important that the \code{n.iter} argument
of \code{\link[psych:fa]{psych::fa()}} was set to a realistic number, because otherwise, no
confidence intervals will be available.}

\item{xlab}{The label for the x axis.}

\item{colors}{The colors used for the factors. The default uses the discrete
\code{viridis} palette, which is optimized for perceptual uniformity,
maintaining its properties when printed in grayscale, and designed for
colourblind readers.}

\item{labels}{The labels to use for the items (on the Y axis).}

\item{theme}{The ggplot2 theme to use.}

\item{sortAlphabetically}{Whether to sort the items alphabetically.}

\item{\dots}{Additional arguments will be passed to
\code{\link[=ggDiamondLayer]{ggDiamondLayer()}}. This can be used to set, for example, the
transparency (alpha value) of the diamonds to a lower value using e.g.
\code{alpha=.5}.}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot with several
\code{\link[=ggDiamondLayer]{ggDiamondLayer()}}s is returned.
}
\description{
This function uses the \code{\link[=diamondPlot]{diamondPlot()}} to visualise the results of
a factor analyses. Because the factor loadings computed in factor analysis
are point estimates, they may vary from sample to sample. The factor
loadings for any given sample are usually not relevant; samples are but
means to study populations, and so, researchers are usually interested in
population values for the factor loadings. However, tables with lots of
loadings can quickly become confusing and intimidating. This function aims
to facilitate working with and interpreting factor analysis based on
confidence intervals by visualising the factor loadings and their confidence
intervals.
}
\examples{

\dontrun{
### (Not run during testing because it takes too long and
###  may generate warnings because of the bootstrapping of
###  the confidence intervals)

factorLoadingDiamondCIplot(psych::fa(psych::Bechtoldt,
                                     nfactors=2,
                                     n.iter=50,
                                     n.obs=200));

### And using a lower alpha value for the diamonds to
### make them more transparent

factorLoadingDiamondCIplot(psych::fa(psych::Bechtoldt,
                                     nfactors=2,
                                     n.iter=50,
                                     n.obs=200),
                           alpha=.5,
                           size=1);
}

}
\seealso{
\code{\link[psych:fa]{psych::fa()}}ss, \code{\link[=meansDiamondPlot]{meansDiamondPlot()}},
\code{\link[=meanSDtoDiamondPlot]{meanSDtoDiamondPlot()}}, \code{\link[=diamondPlot]{diamondPlot()}},
\code{\link[=ggDiamondLayer]{ggDiamondLayer()}}
}
\author{
Gjalt-Jorn Peters

Maintainer: Gjalt-Jorn Peters \href{mailto:ufs@opens.science}{ufs@opens.science}
}
\keyword{hplot}
