% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Groningen.R
\docType{data}
\name{groningen_1}
\alias{groningen_1}
\title{Primary colors of the University of Groningen, Netherlands}
\format{
An object of class \code{character} of length 3.
}
\source{
Color definitions are based on \href{https://www.rug.nl}{UGroningen}'s 
\href{https://www.rug.nl/about-ug/practical-matters/huisstijl/huisstijl-basiselementen/kleuren}{House style} 
specifications.
}
\usage{
groningen_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{groningen_1} provides the three primary colors 
of the \href{https://www.rug.nl}{University of Groningen}, Netherlands.
}
\details{
The 4 primary colors are 
\code{"RUG red"} (defined as RGB \code{220 0 45} or HEX \code{"#dc002d"}),
\code{"white"} (defined as RGB \code{220 0 45} or HEX \code{"#FFFFFF"}), and 
\code{"black"} (defined as RGB \code{0 0 0} or HEX \code{"#000000"}).

\code{groningen_1} uses the RGB color definitions.
}
\examples{
groningen_1
unikn::seecol(groningen_1, col_bg = "grey90",  
              main = "Primary colors of the University of Groningen")  # view palette
# unikn::demopal(groningen_1, main = "Illustrating the colors of Groningen")  # demo

}
\seealso{
\code{\link{groningen_2}} for RUG's secondary color palette; 
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Dutch university color palettes: 
\code{\link{groningen_2}}
}
\author{
P. M. Santos to \strong{unicol}, 2023-08-17.
}
\concept{Dutch university color palettes}
\keyword{datasets}
