% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Uni_Regensburg.R
\docType{data}
\name{uni_regensburg_1}
\alias{uni_regensburg_1}
\title{General colors of the University of Regensburg, Germany}
\format{
An object of class \code{character} of length 12.
}
\source{
Color definitions are based on 
\url{https://www.uni-regensburg.de/interne-kommunikation/corporate-design/}.
}
\usage{
uni_regensburg_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{uni_regensburg_1} provides the general (administrative and service-oriented) colors 
of the \href{https://www.uni-regensburg.de}{University of Regensburg}, Germany.
}
\details{
Named colors of \code{uni_regensburg_1} correspond to the following UR services:

\enumerate{
\item \code{neutralgrau}: Main color (UR-Hausfarbe, Logo)  
\item \code{blaugrau}: Leitung, Organe und Verwaltung (LOV, Ausnahme: Referate I/3, I/4, I/5, I/6)
\item \code{schwarzrot}: Chancengleichheit und Familie (Familien-Service, Frauenbeauftragte, Frauenfoerderung, Gleichstellung)
\item \code{schilfgruen}: Service-Einrichtungen der Verwaltung für Studierende (Akademisches Auslandsamt, Studentenkanzlei, Zentrales Pruefungssekretariat, Zentrale Studienberatung, Senatsbeauftragter für Behinderte und chronisch Kranke) 
\item \code{dianthusrot}: Universitaetsbibliothek (UB)
\item \code{saphirblau}: Rechenzentrum (RZ)
\item \code{farngruen}: Zentrum fuer Weiterbildung
\item \code{rotbraun}: Zentrum fuer Sprache und Kommunikation (ZSK)
\item \code{perlviolett}: Europaeum (Ost-West-Zentrum)
\item \code{violettrot}: Zentrum fuer Hochschul- und Wissenschaftsdidaktik (ZHW)
\item \code{gruenbraun}: Regensburger Universitätszentrum fuer Lehrerbildung (RUL)
\item \code{wasserblau}: Sportzentrum (SZ)
}

When coloring large areas, named colors may be used in shades of 70%.
}
\examples{
uni_regensburg_1
unikn::seecol(uni_regensburg_1, main = "General colors of the University of Regensburg")
unikn::demopal(uni_regensburg_1, alpha = .70, type = 2, 
               main = "General colors of Regensburg University")

}
\seealso{
\code{\link{uni_regensburg_2}} and \code{\link{uni_regensburg_3}} for the faculty colors of the University of Regensburg;  
\code{\link[unikn]{seecol}} for viewing and comparing color palettes; 
\code{\link[unikn]{usecol}} for using color palettes; 
\code{\link[unikn]{simcol}} for finding similar colors; 
\code{\link[unikn]{newpal}} for defining new color palettes; 
\code{\link[unikn]{grepal}} for finding named colors.

Other German university color palettes: 
\code{\link{fu_0_2023}},
\code{\link{fu_1}},
\code{\link{fu_1_2023}},
\code{\link{fu_2}},
\code{\link{fu_2_2023}},
\code{\link{fu_3}},
\code{\link{fu_3_2023}},
\code{\link{fu_4}},
\code{\link{hu_1}},
\code{\link{hu_1_2022}},
\code{\link{hu_1_digital}},
\code{\link{hu_2}},
\code{\link{hu_2_2022}},
\code{\link{hu_3_accent}},
\code{\link{lmu_1}},
\code{\link{lmu_2}},
\code{\link{lmu_3}},
\code{\link{rptu}},
\code{\link{uni_bonn_1}},
\code{\link{uni_bonn_2}},
\code{\link{uni_freiburg_0}},
\code{\link{uni_freiburg_1}},
\code{\link{uni_freiburg_2}},
\code{\link{uni_freiburg_blue}},
\code{\link{uni_freiburg_br}},
\code{\link{uni_freiburg_grey}},
\code{\link{uni_freiburg_info}},
\code{\link{uni_goettingen_1}},
\code{\link{uni_goettingen_2}},
\code{\link{uni_goettingen_3}},
\code{\link{uni_halle}},
\code{\link{uni_hamburg_1}},
\code{\link{uni_hamburg_2}},
\code{\link{uni_heidelberg}},
\code{\link{uni_jena_1}},
\code{\link{uni_jena_2}},
\code{\link{uni_kassel}},
\code{\link{uni_kiel_1}},
\code{\link{uni_kiel_2}},
\code{\link{uni_koeln_1}},
\code{\link{uni_koeln_2}},
\code{\link{uni_konstanz_1}},
\code{\link{uni_konstanz_2}},
\code{\link{uni_magdeburg_1}},
\code{\link{uni_magdeburg_2}},
\code{\link{uni_magdeburg_3}},
\code{\link{uni_mannheim_1}},
\code{\link{uni_mannheim_2}},
\code{\link{uni_potsdam}},
\code{\link{uni_regensburg_2}},
\code{\link{uni_regensburg_3}},
\code{\link{uni_stuttgart_1}},
\code{\link{uni_stuttgart_print}},
\code{\link{uni_ulm_1}},
\code{\link{uni_ulm_2}}
}
\author{
\strong{unicol}, 2022-11-25.
}
\concept{German university color palettes}
\keyword{datasets}
