% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ANU.R
\docType{data}
\name{anu_1}
\alias{anu_1}
\title{Background colours of Australian National University, Australia}
\format{
An object of class \code{character} of length 4.
}
\source{
\href{https://www.anu.edu.au}{ANU}'s 
\href{https://webpublishing.anu.edu.au/web-style-guide/colours}{Web Style Guide: Colours}.
}
\usage{
anu_1
}
\value{
A named vector of colors (HEX/HTML codes of type character).
}
\description{
\code{anu_1} provides the four background colors 
of the \href{https://www.anu.edu.au}{Australian National University}, Canberra, Australia.
}
\details{
ANU's primary colour is \code{ANU gold}, defined as HEX \code{"#BE830E"},  
and with a lighter variant \code{ANU gold tint}, defined as \code{"#F5EDDE"}.


The ANU identity features a restrained colour palette designed for maximum brand recognition.

While designing the landing pages/collaterals \code{ANU gold} should be rarely used as a background colour. 
It is considered as a key highlight colour, supported by the strong use of black and white. 
The use of \code{ANU gold} should not cover more than 1/8 of the page/banner.
}
\examples{
anu_1
unikn::seecol(anu_1, col_bg = "grey95",  
              main = "Background colours of the Australian National University (ANU)")

}
\seealso{
\code{\link{anu_2}} for font colours of Australian National University;
\code{\link[unikn]{seecol}} for viewing and comparing color palettes;
\code{\link[unikn]{usecol}} for using color palettes;
\code{\link[unikn]{simcol}} for finding similar colors;
\code{\link[unikn]{newpal}} for defining new color palettes;
\code{\link[unikn]{grepal}} for finding named colors.

Other Australian university color palettes: 
\code{\link{anu_2}},
\code{\link{mq_1}},
\code{\link{mq_2}},
\code{\link{wollongong_1}},
\code{\link{wollongong_2}}
}
\author{
\strong{unicol}, 2023-09-04.
}
\concept{Australian university color palettes}
\keyword{datasets}
