% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood_stats.R
\name{likelihood_stats}
\alias{likelihood_stats}
\alias{print.likelihood_stats}
\title{Likelihood-based statistics of fit for \code{unitquantreg} objects.}
\usage{
likelihood_stats(..., lt = NULL)

\method{print}{likelihood_stats}(x, ...)
}
\arguments{
\item{...}{\code{\link{unitquantreg}} objects separated by commas.
Not use in \code{print} method.}

\item{lt}{a list with one or more \code{\link{unitquantreg}} objects.}

\item{x}{object of class \code{likelihood_stats} obtained from \code{likelihood_stats}
function.}
}
\value{
A list with class \code{"likelihood_stats"} containing the following
components:
\item{call}{the matched call.}
\item{stats}{ordered matrix according AIC value containg the likelihood
based statistics.}
}
\description{
Computes the likelihood-based statistics (Neg2LogLike, AIC, BIC and HQIC)
from \code{unitquantreg} objects.
}
\details{
Neg2LogLike: The log-likelihood is reported as \deqn{Neg2LogLike= -2\log(L)}

AIC: The Akaike's information criterion (AIC) is defined as \deqn{AIC = -2\log(L)+2p}

BIC: The Schwarz Bayesian information criterion (BIC) is defined as \deqn{BIC =  -2\log(L) + p\log(n)}

HQIC: The Hannan and Quinn information criterion (HQIC)  is defined as \deqn{HQIC =  -2\log(L) + 2p\log[\log(n)]}
where \eqn{L} is the likelihood function.
}
\examples{
data(sim_bounded, package = "unitquantreg")
sim_bounded_curr <- sim_bounded[sim_bounded$family == "uweibull", ]

models <- c("uweibull", "kum", "ulogistic")
lt_fits <- lapply(models, function(fam) {
  unitquantreg(formula = y1 ~ x, tau = 0.5, data = sim_bounded_curr,
               family = fam)
})

ans <- likelihood_stats(lt = lt_fits)
ans

}
\references{
Akaike, H. (1974). A new look at the statistical model identification. \emph{IEEE Transaction on Automatic Control}, \bold{19}(6), 716--723.

Hannan, E. J. and Quinn, B. G. (1979). The determination of the order of an autoregression. \emph{Journal of the Royal Statistical Society, Series B}, \bold{41}(2), 190--195.

Schwarz, G. (1978). Estimating the dimension of a model. \emph{Annals of Statistics}, \bold{6}(2), 461--464.
}
\author{
André F. B. Menezes

Josmar Mazucheli
}
