% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-prez_pwr.R
\docType{data}
\name{prez_pwr}
\alias{prez_pwr}
\title{Presidential Power.}
\format{
A data frame with 365 rows and 3 variables.
\describe{
\item{president}{Sitting President at time of the poll.}
\item{party}{Political party of the respondent with levels d(emocrat)
and r(epublican).}
\item{has_pwr}{Respondent answer to the question: "Is
the price of gasoline something the president can do
alot about, or is that beyond the president's control?"}
}
}
\source{
\href{https://www.pewresearch.org/short-reads/2013/07/25/can-a-president-control-gas-prices-depends-on-when-you-ask/}{Pew Research Center, May 2006 & March 2012}.
}
\usage{
prez_pwr
}
\description{
Data from a Pew Research Center poll about Presidential
power/control over gas prices.
}
\examples{
library(ggplot2)
ggplot(prez_pwr, aes(has_pwr, fill = party)) +
  geom_bar() +
  labs(
    title = "Is the price of gasoline something the president can do alot about?",
    x = "",
    y = "Number of respondents",
    fill = "Respondent Party"
  ) +
  facet_wrap(~president)
}
\keyword{datasets}
