% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_time.R
\name{benchmark_time}
\alias{benchmark_time}
\title{Compare Time with a Benchmark}
\usage{
benchmark_time(
  data,
  column,
  benchmark,
  alpha,
  remove_missing = FALSE,
  input = "long",
  output = "console"
)
}
\arguments{
\item{data}{dataframe}

\item{column}{a column or vector of time values}

\item{benchmark}{benchmark}

\item{alpha}{alpha}

\item{remove_missing}{TRUE/FALSE (Default is TRUE)}

\item{input}{Default: "long" - long form of data, "values" to pass values directly. If using this option, must specify count and total.}

\item{output}{Default: "console" - prints output in console and returns tibble invisibly.}
}
\value{
lower_ci, upper_ci, t, probability
}
\description{
Compare Time with a Benchmark
}
\examples{
data <- data.frame(time = c(60, 53, 70, 42, 62, 43, 81))
benchmark_time(data, column = time, benchmark = 60, alpha = 0.05)
}
