#' Misclassification Estimates Based on CHAMPS Data
#'
#' Estimates of misclassification matrices using the modeling framework from Pramanik et al. (2025)
#' and the limited paired MITS-VA data from the Child Health and Mortality Prevention Surveillance
#' (CHAMPS) project.
#'
#' @format A nested list.
#' \describe{
#'   \item{age_group}{"neonate" for 0-27 days, and "child" for 1-59 months}
#'   \item{va_algo}{"eava", "insilicova", and "interva"}
#'   \item{estimate types}{"postsumm" contains posterior summaries, "postmean" contains the posterior means, and "asDirich" contains Dirichlet approximation for each CHAMPS cause and country.}
#'   \item{country}{"Bangladesh", "Ethiopia", "Kenya", "Mali", "Mozambique", "Sierra Leone", "South Africa", "other"}
#'   \item{version}{Date stamp for version control of tracking updates. Only for package maintainers.}
#' }
#'
#' @details
#' \code{Mmat_champs[[age_group]][[va_algo]][["postsumm"]][[country]]} contains posterior summaries of misclassification matrix for the a desired age_group, va_algo, and country.
#' It is an array of dimension the number of posterior summaries X CHAMPS broad cause X VA broad cause.
#' For example, if analyzing "neonate" age group using "insilicova" algorithm in "Mozambique",
#' \itemize{
#'    \item \code{Mmat_champs$neonate$insilicova$postsumm$Mozambique[,"pneumonia","pneumonia"]} are posterior summaries of the sensitivity for "pneumonia".
#'    \item \code{Mmat_champs$neonate$insilicova$postsumm$Mozambique[,"pneumonia","ipre"]} are posterior summaries of the false negative rate for CHAMPS broad cause "pneumonia" and VA broad cause "ipre".
#' }
#'
#' Posterior samples are available from the GitHub repository <https://github.com/sandy-pramanik/Mmat_champs>.
#'
#' .rda file is available under the release: <https://github.com/sandy-pramanik/Mmat_champs/releases/tag/20241004>.
#'
#' \code{Mmat_champs[[age_group]][[va_algo]][["postmean"]][[country]]} contains posterior means.
#'
#' \code{Mmat_champs[[age_group]][[va_algo]][["asDirich"]][[country]]} contains Dirichlet approximations of its posterior.
#'
#' They are matrices of dimension CHAMPS broad cause X VA broad cause.
#' For example, if analyzing "neonate" age group using "insilicova" algorithm in "Mozambique",
#' \itemize{
#'    \item \code{Mmat_champs$neonate$insilicova$postmean$Mozambique["pneumonia","pneumonia"]} is the posterior mean of sensitivity for "pneumonia".
#'    \item \code{Mmat_champs$neonate$insilicova$postmean$Mozambique["pneumonia","ipre"]} is the posterior mean of false negative rate for CHAMPS broad cause "pneumonia" and VA broad cause "ipre".
#' }
#'
#' Similarly, \code{Mmat_champs$neonate$insilicova$asDirich$Mozambique["pneumonia",]} are parameters of Dirichlet distribution approximating the posterior of classification rates of different broad causes for the CHAMPS broad cause "pneumonia".
#'
#' @references
#' Pramanik, S, et al. (2025). *Modeling structure and country-specific heterogeneity in misclassification matrices of verbal autopsy-based cause of death classifiers*.
#' Annals of Applied Statistics, 19(2):1214–1239. ISSN 1932-6157.
#'
#' Taylor, A, et al. (2020). *Initial findings from a novel population-based child mortality surveillance approach: a descriptive study*.
#' Lancet Glob Health, 8(7):e909-e919.
#'
#' @examples
#'
#' \donttest{
#'
#' ## misclassification estimates
#' data(Mmat_champs)
#'
#' # misclassification estimates for "neonate" age group and "insilicova" algorithm in Mozambique
#' ## posterior summaries of the sensitivity of "pneumonia"
#' Mmat_champs$neonate$insilicova$postsumm$Mozambique[,"pneumonia","pneumonia"]
#'
#' ## posterior summaries of the false negative rates
#' ## CHAMPS cause "pneumonia" and VA cause "ipre"
#' Mmat_champs$neonate$insilicova$postsumm$Mozambique[,"pneumonia","ipre"]
#'
#' # COMSA-Mozambique: Example (Publicly Available Version)
#' # Individual-Level Specific (High-Resolution) Cause of Death Data
#' data(comsamoz_public_openVAout)
#' head(comsamoz_public_openVAout$data)  # head of the data
#'
#' ## VA-calibration for the "neonate" age group and "insilicova" algorithm
#' calib_out1 = vacalibration(va_data =
#'                                      setNames(list(comsamoz_public_openVAout$data),
#'                                               list(comsamoz_public_openVAout$va_algo)),
#'                            age_group = comsamoz_public_openVAout$age_group,
#'                            country = "Mozambique")
#'
#' calib_out2 = vacalibration(va_data =
#'                                      setNames(list(comsamoz_public_openVAout$data),
#'                                               list(comsamoz_public_openVAout$va_algo)),
#'                            age_group = comsamoz_public_openVAout$age_group,
#'                            country = "Mozambique",
#'   Mmat.asDirich = list("insilicova" = Mmat_champs$neonate$insilicova$asDirich$Mozambique))
#' ## By default the function fetches the desired misclassification estimates from
#' ## the stored Mmat_champs.
#'
#' ## So calib_out1 (where we don't specify the misclassification) and
#' ## calib_out2 (where we specify) are identical.
#'
#' }
#'
"Mmat_champs"
