% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valhalla.R
\name{print_trip}
\alias{print_trip}
\title{Print Trip Summary and Turn-By-Turn Directions}
\usage{
print_trip(trip, all_details = FALSE)
}
\arguments{
\item{trip}{A trip response from \code{valhallr::route()}.}

\item{all_details}{Boolean. Should we print each turn-by-turn instruction
along with an overall summary?}
}
\value{
The input \code{trip} object, invisibly.
}
\description{
Print Trip Summary and Turn-By-Turn Directions
}
\examples{
\dontrun{
  library(valhallr)
  # set up origin and destination data
  from <- test_data("uottawa")
  to <- test_data("cdntirecentre")

  # calculate the trip
  trip <- route(from = from, to = to)

  # show overall trip information
  print_trip(trip, all_details = FALSE)

  # make an interactive map of the trip using the leaflet package
  map_trip(trip, method = "leaflet")
}
}
