% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getResults.R
\name{getResults}
\alias{getResults}
\title{Get results from Mturk}
\usage{
getResults(
  batch_id = "unspecified",
  hit_ids,
  retry = TRUE,
  retry_in_seconds = 60,
  AWS_id = Sys.getenv("AWS_ACCESS_KEY_ID"),
  AWS_secret = Sys.getenv("AWS_SECRET_ACCESS_KEY"),
  sandbox = getOption("pyMTurkR.sandbox", TRUE)
)
}
\arguments{
\item{batch_id}{any number or string to annotate the batch}

\item{hit_ids}{hit ids returned from the MTurk API, i.e., output of sendTasks()}

\item{retry}{if TRUE, retry retriving results from Mturk API five times; default to TRUE}

\item{retry_in_seconds}{default to 60 seconds}

\item{AWS_id}{AWS_ACCESS_KEY_ID}

\item{AWS_secret}{AWS_SECRET_ACCESS_KEY}

\item{sandbox}{sanbox setting}
}
\value{
a data frame with columns:
\item{batch_id}{an annotation for the batch}
\item{local_task_id}{an identifier for the task in the batch}
\item{mturk_hit_id}{the ID of the HIT in MTurk}
\item{assignment_id}{the ID of the assignment in MTurk}
\item{worker_id}{the ID of the worker who completed the assignment}
\item{result}{the worker's response to the task}
\item{completed_at}{the time when the worker submitted the assignment}
}
\description{
Get results from Mturk
}
\details{
this function works for complete or incomplete batches
}
