% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detect_fixed_variables.R
\name{detect_fixed_variables}
\alias{detect_fixed_variables}
\title{Detect fixed variables}
\usage{
detect_fixed_variables(x, eps = x$options("lin.eq.eps"), ...)
}
\arguments{
\item{x}{\code{\link[validate:validator]{validate::validator()}} object with the validation rules.}

\item{eps}{detected fixed values will have this precission.}

\item{...}{not used.}
}
\description{
Detects variables that are constrained by the rule set to have one fixed value.
To simplify a rule set, these variables can be substituted with their value.
See examples.
}
\examples{
library(validate)
rules <- validator( x >= 0
                  , x <= 0
                  )
detect_fixed_variables(rules)
simplify_fixed_variables(rules)

rules <- validator( x1 + x2 + x3 == 0
                  , x1 + x2 >= 0
                  , x3 >= 0
                  )
simplify_fixed_variables(rules)
}
\seealso{
\code{\link[=simplify_fixed_variables]{simplify_fixed_variables()}}

Other redundancy: 
\code{\link{detect_redundancy}()},
\code{\link{is_implied_by}()},
\code{\link{remove_redundancy}()},
\code{\link{simplify_fixed_variables}()},
\code{\link{simplify_rules}()}
}
\concept{redundancy}
