% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{money.ball}
\alias{money.ball}
\title{$1,000,000 Money Ball}
\format{A data frame with 100 rows and 7 variables:
\describe{
  \item{date}{date of draw}
  \item{moneyball}{money ball result: yes or no}
  \item{N1}{1st number in order}
  \item{N2}{2nd number in order}
  \item{N3}{3rd number in order}
  \item{N4}{4th number in order}
  \item{N5}{5th number in order}
}}
\source{
\url{https://www.valottery.com}
}
\usage{
money.ball
}
\description{
Historical data for the $1,000,000 Money Ball game. Game Play: pick five numbers
1 - 35, the Lottery then selects five numbered balls. If the Gold Million Dollar
Money Ball is drawn before all five numbers have been selected, the top prize
jumps to $1,000,000. Note: This game was discontinued 8/29/15.
}
\examples{
## probability of drawing money ball before first 5 balls
(1/36) + (1/35) + (1/34) + (1/33) + (1/32)
## observed money ball results
prop.table(table(money.ball$moneyball))
## simulate money ball draws before first 5 draws
set.seed(123)
mean(replicate(1000, any(sample(c(1:35,"mb"),5)=="mb")))
}
\keyword{datasets}

