## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(valueprhr)

## ----example-data-------------------------------------------------------------
set.seed(123)
years <- 2000:2019
sectors <- LETTERS[1:5]

direct <- data.frame(Year = years)
production <- data.frame(Year = years)

for (s in sectors) {
  direct[[s]] <- 100 + cumsum(rnorm(20, 2, 1))
  production[[s]] <- direct[[s]] * 1.02 + rnorm(20, 0, 2)
}

## ----prepare-panel------------------------------------------------------------
panel <- prepare_panel_data(direct, production)
head(panel)

## ----twoway-fe, eval=FALSE----------------------------------------------------
# if (requireNamespace("plm", quietly = TRUE)) {
#   twoway_result <- fit_twoway_fe(panel)
#   print(twoway_result$r2_within)
# }

## ----mundlak, eval=FALSE------------------------------------------------------
# if (requireNamespace("plm", quietly = TRUE)) {
#   mundlak_result <- fit_mundlak_cre(panel)
#   print(mundlak_result$variance_components)
# }

## ----comparison, eval=FALSE---------------------------------------------------
# comparison <- compare_models(
#   twoway_result = twoway_result,
#   mundlak_result = mundlak_result
# )
# print(comparison)

## ----cv, eval=FALSE-----------------------------------------------------------
# cv_results <- rolling_window_cv(panel, window_sizes = c(10, 15))
# cv_summary <- summarize_cv_results(cv_results)
# print(cv_summary)

## ----breaks, eval=FALSE-------------------------------------------------------
# if (requireNamespace("strucchange", quietly = TRUE)) {
#   break_tests <- test_structural_breaks(panel)
#   print(format_break_results(break_tests))
# }

## ----full-analysis, eval=FALSE------------------------------------------------
# results <- run_full_analysis(
#   direct, production,
#   run_bayesian = FALSE,
#   run_cv = TRUE,
#   run_breaks = TRUE
# )

