% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{rolling_window_cv}
\alias{rolling_window_cv}
\title{Rolling Window Cross-Validation}
\usage{
rolling_window_cv(
  panel_data,
  window_sizes = c(20L, 30L),
  step_size = 2L,
  test_horizon = 3L,
  verbose = TRUE
)
}
\arguments{
\item{panel_data}{Data frame in panel format.}

\item{window_sizes}{Integer vector of training window sizes. Default c(20, 30).}

\item{step_size}{Integer step between windows. Default 2.}

\item{test_horizon}{Integer number of periods to forecast. Default 3.}

\item{verbose}{Logical. Print progress. Default TRUE.}
}
\value{
A data frame with validation results for each window, including:
\describe{
  \item{window_size}{Training window size}
  \item{window_start}{Start year of training window}
  \item{window_end}{End year of training window}
  \item{rmse_fe_all}{RMSE for FE model on all test observations}
  \item{rmse_m_all}{RMSE for Mundlak model on all test observations}
  \item{n_test_common}{Number of test obs from sectors in training}
  \item{n_test_new}{Number of test obs from new sectors}
}
}
\description{
Performs time-series cross-validation using rolling windows, comparing
fixed effects and Mundlak models.
}
\details{
For each rolling window, the function fits both a fixed effects model
(by sector) and a Mundlak CRE model, then evaluates predictions on
the test period. Results are separated by whether test sectors were
seen during training (common) or not (new).
}
\examples{
\donttest{
if (requireNamespace("plm", quietly = TRUE)) {
  set.seed(123)
  panel <- data.frame(
    year = rep(2000:2029, 5),
    sector = rep(LETTERS[1:5], each = 30),
    log_direct = rnorm(150, 5, 0.5),
    log_production = rnorm(150, 5, 0.5)
  )
  panel$log_production <- panel$log_direct * 0.95 + rnorm(150, 0, 0.1)

  cv_results <- rolling_window_cv(panel, window_sizes = c(15, 20))
  print(head(cv_results))
}
}

}
