% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision_methods.R
\name{summary.precision_study}
\alias{summary.precision_study}
\title{Summary method for precision_study objects}
\usage{
\method{summary}{precision_study}(object, ...)
}
\arguments{
\item{object}{An object of class \code{precision_study}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
An object of class \code{summary.precision_study} containing:
\describe{
\item{call}{The original function call.}
\item{n}{Number of observations.}
\item{n_excluded}{Number of observations excluded due to NAs.}
\item{design}{Design information list.}
\item{settings}{Analysis settings.}
\item{variance_components}{Data frame of variance components.}
\item{precision}{Data frame of precision estimates.}
\item{anova_table}{ANOVA table (if method = "anova").}
\item{by_sample}{Results by sample (if multiple samples).}
}
}
\description{
Provides a detailed summary of precision study results, including
variance components, ANOVA table (for ANOVA method), precision estimates
with confidence intervals, and design information.
}
\examples{
# Create example data
set.seed(42)
data <- data.frame(
  day = rep(1:5, each = 4),
  value = rnorm(20, mean = 100, sd = 5)
)
data$value <- data$value + rep(rnorm(5, 0, 3), each = 4)

prec <- precision_study(data, value = "value", day = "day")
summary(prec)

}
\seealso{
\code{\link[=print.precision_study]{print.precision_study()}} for concise output
}
