% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modeler.R
\name{stan_inits}
\alias{stan_inits}
\title{Calculate Initial Values for Stan VM Model}
\usage{
stan_inits(stan.data, design = c("V -> Y", "V -> M -> Y", "V", "X -> V",
  "X -> V -> Y", "X -> M -> V"), useU, ...)
}
\arguments{
\item{stan.data}{A list containing the data to be passed to Stan}

\item{design}{A character string indicating the type of model to be run.  One of
\dQuote{V -> Y} for variability predicting an outcome,
\dQuote{V -> M -> Y} for mediation of variability on an outcome,
\dQuote{V} to take posterior samples of individual variability estimates alone.}

\item{useU}{whether to include the random intercepts}

\item{\dots}{Additional arguments (not currently used)}
}
\value{
A named list containing the initial values for Stan.
}
\description{
Internal function used to get rough starting values for a
variability model in Stan.  Uses inidivudal standard deviations, means,
and linear regressions.
}
\examples{
# make me!
}
\author{
Joshua F. Wiley <josh@elkhartgroup.com>
}
\keyword{models}

