% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run.annotation.R
\name{run.annotation}
\alias{run.annotation}
\title{Run annotation on a set of VCF files}
\usage{
run.annotation(vcf.specification, output.directory = NULL,
  job.name.prefix = NULL, job.group = NULL, quiet = FALSE,
  verify.options = !quiet)
}
\arguments{
\item{vcf.specification}{Data frame detailing VCF files to be processed, from \code{prepare.vcf.specification}.}

\item{output.directory}{Path to folder where code and log files should be stored in their respective subdirectories. 
If not supplied, code and log files will be stored in the directory with each VCF file.}

\item{job.name.prefix}{Prefix to be added before VCF name in job name. Defaults to 'annotate', but should be changed if 
running multiple callers to avoid}

\item{job.group}{Group job should be associated with on cluster}

\item{quiet}{Logical indicating whether to print commands to screen rather than submit them}

\item{verify.options}{Logical indicating whether to run verify.varitas.options}
}
\value{
Data frame with details of variant files
}
\description{
Takes a data frame with paths to VCF files, and runs ANNOVAR annotation on each file.
	To allow for smooth connections with downstream pipeline steps, the function returns a variant
 specification data frame that can be used as input to merging steps.
}
\examples{
run.annotation(
  data.frame(
    sample.id = c('a', 'b'),
    vcf = c('a.vcf', 'b.vcf'),
    caller = c('mutect', 'mutect')
  ),
  output.directory = '.',
  quiet = TRUE
)

}
