% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ve.R
\name{coxphParametricSampling}
\alias{coxphParametricSampling}
\title{Accounting for the uncertainty on the fitted \code{"coxph"} model and observed data}
\usage{
coxphParametricSampling(Fit, nboot = 2000, Data.vaccinated, Data.control)
}
\arguments{
\item{Fit}{an object of class inheriting from \code{"coxph"} representing the fitted model}

\item{nboot}{a numeric value for number of bootstrap samples for confidence interval construction}

\item{Data.vaccinated}{a data frame for the vaccinated group, containing the variables in the fitted model}

\item{Data.control}{a data frame for the control group, containing the variables in the fitted model}
}
\value{
a vector of vaccine efficacy values \code{VE_set}, with length of \code{nboot}
}
\description{
\code{coxphParametricSampling} is used for vaccine efficacy confidence interval construction. 
It provides a vector of vaccine efficacy values, with length of \code{nboot}. 95\% confidence interval, defined by 2.5th and 97.5th quantile of this vector,
accounts for the uncertainty on the model fit (via parametric resampling of the posterior distribution of the model parameters) and observed data (via bootstrapping).
}
\examples{
# Load required packages
library(dplyr)
library(survival)

# Load an example dataset
data(data_temp)
Data.vaccinated <- filter(data_temp, vaccine == 1)
Data.control <- filter(data_temp, vaccine == 0)

# Fit Cox proportional hazards model relating neutralizing titer 
# to time to disease or end of follow-up
coxFit <- coxph(Surv(time_event, disease_any) ~ nAb1, data = data_temp)

# Estimate 95\\% confidence interval of vaccine efficacy based on the fitted model
efficacySet <- coxphParametricSampling(coxFit, nboot = 500, Data.vaccinated, Data.control)
CI <- lapply(EfficacyCI(efficacySet),"*", 100)

}
