% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_chromR.R
\name{create.chromR}
\alias{create.chromR}
\alias{vcfR2chromR}
\alias{vcf2chromR}
\alias{seq2chromR}
\alias{ann2chromR}
\title{Create chromR object}
\usage{
create.chromR(vcf, name = "CHROM", seq = NULL, ann = NULL, verbose = TRUE)

vcfR2chromR(x, vcf)

seq2chromR(x, seq = NULL)

ann2chromR(x, gff)
}
\arguments{
\item{vcf}{an object of class vcfR}

\item{name}{a name for the chromosome (for plotting purposes)}

\item{seq}{a sequence as a DNAbin object}

\item{ann}{an annotation file (gff-like)}

\item{verbose}{should verbose output be printed to the console?}

\item{x}{an object of class chromR}

\item{gff}{a data.frame containing annotation data in the gff format}
}
\description{
Creates and populates an object of class chromR.
}
\details{
Creates and names a chromR object from a name, a chromosome (an ape::DNAbin object), variant data (a vcfR object) and annotation data (gff-like).
The function \strong{create.chromR} is a wrapper which calls functions to populate the slots of the chromR object.

The function \strong{vcf2chromR} is called by create.chromR and transfers the data from the slots of a vcfR object to the slots of a chromR object.
It also tries to extract the 'DP' and 'MQ' fileds (when present) from the fix slot's INFO column.
It is not anticipated that a user would need to use this function directly, but its placed here in case they do.

The function \strong{seq2chromR} is currently defined as a generic function.
This may change in the future.
This function takes an object of class DNAbin and assigns it to the 'seq' slot of a chromR object.

The function \strong{ann2chromR} is called by create.chromR and transfers the information from a gff-like object to the 'ann' slot of a chromR object.
It is not anticipated that a user would need to use this function directly, but its placed here in case they do.
}
\examples{
library(vcfR)
data(vcfR_example)
chrom <- create.chromR('sc50', seq=dna, vcf=vcf, ann=gff)
head(chrom)
chrom
plot(chrom)

chrom <- masker(chrom, min_QUAL = 1, min_DP = 300, max_DP = 700, min_MQ = 59, max_MQ = 61)
chrom <- proc.chromR(chrom, win.size=1000)

plot(chrom)
chromoqc(chrom)




}
\seealso{
\code{\link{chromR-class}},
\code{\link{vcfR-class}},
\code{\link[ape]{DNAbin}},
\href{https://github.com/samtools/hts-specs}{VCF specification}
\href{https://github.com/The-Sequence-Ontology/Specifications/blob/master/gff3.md}{gff3 format}
}
