% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_rep.R
\name{replicate.prop2}
\alias{replicate.prop2}
\title{Compares and combines 2-group proportion differences in original and
follow-up studies}
\usage{
replicate.prop2(alpha, f11, f12, n11, n12, f21, f22, n21, n22)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{f11}{frequency count for group 1 in original study}

\item{f12}{frequency count for group 2 in original study}

\item{n11}{sample size for group 1 in original study}

\item{n12}{sample size for group 2 in original study}

\item{f21}{frequency count for group 1 in follow-up study}

\item{f22}{frequency count for group 2 in follow-up study}

\item{n21}{sample size for group 1 in follow-up study}

\item{n22}{sample size for group 2 in follow-up study}
}
\value{
A 4-row matrix. The rows are:
\itemize{
\item Row 1 summarizes the original study
\item Row 2 summarizes the follow-up study
\item Row 3 estimates the difference in proportion differences
\item Row 4 estimates the average proportion difference
}

The columns are:
\itemize{
\item Estimate - proportion difference estimate (single study, difference, average)
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function computes confidence intervals from an original study and a
follow-up study where the effect size is a 2-group proportion difference.
Confidence intervals for the difference and average effect size are also
computed. The confidence level for the difference is 1 – 2*alpha, which
is recommended for equivalence testing.
}
\examples{
replicate.prop2(.05, 21, 16, 40, 40, 19, 13, 60, 60)

# Should return:
#                         Estimate         SE         z         p
# Original:             0.11904762 0.10805233 1.1017590 0.2705665
# Follow-up:            0.09677419 0.07965047 1.2149858 0.2243715
# Original - Follow-up: 0.02359056 0.13542107 0.1742016 0.8617070
# Average:              0.11015594 0.06771053 1.6268656 0.1037656
#                                LL        UL
# Original:             -0.09273105 0.3308263
# Follow-up:            -0.05933787 0.2528863
# Original - Follow-up: -0.19915727 0.2463384
# Average:              -0.02255427 0.2428661


}
\references{
\insertRef{Bonett2021}{vcmeta}
}
