% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_model.R
\name{meta.lm.stdmean.ps}
\alias{meta.lm.stdmean.ps}
\title{Meta-regression analysis for paired-samples standardized mean differences}
\usage{
meta.lm.stdmean.ps(alpha, m1, m2, sd1, sd2, cor, n, X, stdzr)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{m1}{vector of estimated means for measurement 1}

\item{m2}{vector of estimated means for measurement 2}

\item{sd1}{vector of estimated SDs for measurement 1}

\item{sd2}{vector of estimated SDs for measurement 2}

\item{cor}{vector of estimated correlations for paired measurements}

\item{n}{vector of sample sizes}

\item{X}{matrix of predictor values}

\item{stdzr}{\itemize{
\item set to 0 for square root unweighted average variance standardizer
\item set to 1 for measurement 1 SD standardizer
\item set to 2 for measurement 2 SD standardizer
}}
}
\value{
Returns a matrix.  The first row is for the intercept with one additional
row per predictor.  The matrix has the following columns:
\itemize{
\item Estimate - OLS estimate
\item SE - standard error
\item z - z-value
\item p - p-value
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
This function estimates the intercept and slope coefficients in a
meta-regression model where the dependent variable is a paired-samples
standardized mean difference. The estimates are OLS estimates with
robust standard errors that accommodate residual heteroscedasticity.
}
\examples{

n <- c(65, 30, 29, 45, 50)
cor <- c(.87, .92, .85, .90, .88)
m1 <- c(20.1, 20.5, 19.3, 21.5, 19.4)
m2 <- c(10.4, 10.2, 8.5, 10.3, 7.8)
sd1 <- c(9.3, 9.9, 10.1, 10.5, 9.8)
sd2 <- c(7.8, 8.0, 8.4, 8.1, 8.7)
x1 <- c(2, 3, 3, 4, 4)
X <- matrix(x1, 5, 1)
meta.lm.stdmean.ps(.05, m1, m2, sd1, sd2, cor, n, X, 0)

# Should return:
#      Estimate         SE         z     p         LL        UL
# b0 1.01740253 0.25361725 4.0115667 0.000  0.5203218 1.5144832
# b1 0.04977943 0.07755455 0.6418635 0.521 -0.1022247 0.2017836


}
\references{
\insertRef{Bonett2009a}{vcmeta}
}
