% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meta_se.R
\name{se.propratio2}
\alias{se.propratio2}
\title{Computes the estimate and standard error for a 2-group log proportion ratio}
\usage{
se.propratio2(f1, f2, n1, n2)
}
\arguments{
\item{f1}{number of participants in group 1 who have the outcome}

\item{f2}{number of participants in group 2 who have the outcome}

\item{n1}{sample size for group 1}

\item{n2}{sample size for group 2}
}
\value{
Returns a one-row matrix:
\itemize{
\item Estimate - estimated log proportion ratio
\item SE - standard error
}
}
\description{
Computes the Price-Bonett standard error of a 2-group proportion ratio using
the frequency count and sample size for each group. The log proportion ratio
and standard error output from this function can be used as input in the
\link[vcmeta]{meta.ave.gen.log} function in applications where compatible
proportion ratios from a combination of 2-group and paired-samples studies
are used in the meta-analysis. If the proportions in each group are small
(less than .1), proportion ratios may be compatible with odds ratios and
then the \link[vcmeta]{meta.ave.gen.log} function could be used to
meta-analyze any combination of log proportion ratios and log odds ratios.
}
\examples{
se.propratio2(31, 16, 40, 40)

# Should return:
#                         Estimate        SE
# Log proportion ratio:  0.6539265 0.2136218


}
\references{
\insertRef{Price2008}{vcmeta}
}
